import carla
from typing import Dict

def convert_dict_location_to_carla_location(location: Dict):
    x = location.get('x', 0)
    y = location.get('y', 0)
    z = location.get('z', 0)
    return carla.Location(x=x, y=y, z=z)

def convert_dict_location_to_carla_waypoint(location: Dict, map: carla.Map):
    location = convert_dict_location_to_carla_location(location)
    waypoint = map.get_waypoint(location)
    return waypoint